const form = document.getElementById('formulario');
const usuario = document.getElementById('usuario');
const clave = document.getElementById('clave');
document.addEventListener('DOMContentLoaded', function () {
    var forms = document.getElementsByClassName('needs-validation');
    // Loop over them and prevent submission
    var validation = Array.prototype.filter.call(forms, function (form) {
        form.addEventListener('submit', function (event) {
            event.preventDefault();
            if (form.checkValidity() === false) {
                event.stopPropagation();
                form.classList.add('was-validated');
            } else {
                const url = base_url + 'home/validar';
                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.upload.addEventListener('progress', function () {
                    document.getElementById('btnAccion').classList.add('disabled');
                });
                http.send(new FormData(this));
                http.addEventListener('load', function () {
                    document.getElementById('btnAccion').classList.remove('disabled');
                });
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        if (res.msg == 'ok') {
                            window.location = base_url + 'inicio';
                        } else {
                            alerta(res.msg, res.icono);
                        }
                    }
                }
            }

        }, false);
    });
})
function alerta(msg, icono) {
    Swal.fire({
        position: 'top-end',
        icon: icono,
        title: msg,
        showConfirmButton: false,
        timer: 3000
    });
}
function recuperarClave(e) {
    e.preventDefault();
    const correo = document.getElementById('correo');
    if (correo.value == '') {
        alerta('El correo es requerido', 'error');
        correo.focus();
    } else {
        const url = base_url + 'usuarios/enviarCorreo';
        const frm = document.getElementById('formulario');
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.upload.addEventListener('progress', function () {
            document.getElementById('btnAccion').classList.add('disabled');
        });
        http.send(new FormData(frm));
        http.addEventListener('load', function () {
            document.getElementById('btnAccion').classList.remove('disabled');
        });
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                const res = JSON.parse(this.responseText);
                frm.reset();
                Swal.fire({
                    icon: res.icono,
                    title: 'Aviso!',
                    text: res.msg,
                })
            }
        }
    }
}
function frmRestablecer(e) {
    e.preventDefault();
    const clave = document.getElementById('clave_nueva').value;
    const confirmar = document.getElementById('confirmar').value;
    if (clave == '' || confirmar == '') {
        alerta('Todo los campos son requeridos', 'warning');
        return false;
    } else if (clave != confirmar) {
        alerta('Las contraseñas no coinciden', 'warning');
        return false;
    } else {
        const frm = document.getElementById('formulario');
        const http = new XMLHttpRequest();
        const url = base_url + "usuarios/resetear";
        http.open("POST", url, true);
        // upload progress event
        http.upload.addEventListener('progress', function (e) {
            document.getElementById('btnAccion').textContent = 'Procesando';
            document.getElementById('btnAccion').setAttribute('disabled', 'disabled');
        });
        http.send(new FormData(frm));
        http.addEventListener('load', function (e) {
            document.getElementById('btnAccion').textContent = 'Restablecer';
            document.getElementById('btnAccion').removeAttribute('disabled');
            frm.reset();
        });
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {

                const res = JSON.parse(this.responseText);
                if (res.icono == 'success') {
                    setTimeout(() => {
                        window.location = base_url;
                    }, 3000);
                }
                alerta(res.msg, res.icono);
            }
        }
    }
}