const id_proveedor = document.getElementById('id_proveedor');
const nombre = document.getElementById('nombre');
const contado = document.getElementById('contado');
const credito = document.getElementById('credito');
const efectivo_recibido = document.getElementById('efectivo_recibido');
const cambio = document.getElementById('cambio');
const anotacion = document.getElementById('anotacion');
const serie = document.getElementById('serie');
const btnAccion = document.getElementById('btnAccion');
const fecha = document.getElementById("fecha");

document.addEventListener('DOMContentLoaded', function () {
    cargarDetalle()

    //Autocomplete - Jquery UI, Buscar Proveedores para la Compra
    $("#buscarProveedor").autocomplete({
        minLength: 2,
        source: function (request, response) {
            $.ajax({
                url: base_url + 'compras/buscarProveedor',
                dataType: "json",
                data: {
                    q: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('id_proveedor').value = ui.item.id;
            document.getElementById('nombre').value = ui.item.nombre;
        }
    })

    //Autocomplete - Jquery UI, Buscar Productos para la Compra
    $("#buscarProducto").autocomplete({
        minLength: 2,
        classes: {"ui-autocomplete": "height-max-autocomplete"},
        source: function (request, response) {
            $.ajax({
                url: base_url + 'compras/buscarProducto',
                dataType: "json",
                data: {
                    pro: request.term
                },
                success: function (data) {
                    if (data.length > 0) {
                        response(data);
                    } else {
                        document.getElementById('error_producto').textContent = 'No hay Producto Similar';
                    }
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('error_producto').textContent = '';
            const id_pro = ui.item.id;
            ingresarCompra(id_pro);
        }
    })

    btnAccion.addEventListener('click', generarCompra)
    fecha.value = new Date().toISOString().substring(0, 10);
})

function ingresarCompra(id_pro) {
    const url = base_url + 'compras/ingresar/' + id_pro;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            cargarDetalle();
            document.getElementById('buscarProducto').value = '';
            document.getElementById('buscarProducto').focus();
            alertas(res.msg, res.icono);
            return;
        }
    }
}

function cargarDetalle() {
    const url = base_url + 'compras/listar/detalle';
    const http = new XMLHttpRequest();
    let select = document.getElementById('serie');
    let option =null;

    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            let html = '';
            res.detalle.forEach(row => {
                html += `<tr>
               <td>${row['descripcion']}</td>
               <td width="150">
               <input type="number" min="1" class="form-control" value="${row['cantidad']}" onchange="cantidadCompra(event, ${row['id']})">
               </td>
               <td width="150">
               <input type="number" step="0.01" min="0.01" class="form-control" value="${row['descuento']}" onchange="descuentoCompra(event, ${row['id']})">
               </td>
               <td width="150">
               <input type="number" step="1.00" min="1" class="form-control" value="${row['precio']}" onchange="precioProducto(event, ${row['id']})">
               </td>
               <td>${row['sub_total']}</td>
               <td>
               <button class="btn btn-danger" type="button" onclick="deleteDetalle(${row['id']})">
               <i class="fas fa-trash-alt"></i></button>
               </td>
               </tr>`;
            });
            document.getElementById("tblDetalle").innerHTML = html;
            document.getElementById("total").value = res.total_pagar.total;

            let selectedOption = select.value;
            select.innerHTML = '';          
            res.series.forEach(row => {
                option = document.createElement('option');
                option.value = row['iduser'];
                option.text = `[${row['iduser']}] ${row['user']}`;
                select.appendChild(option);
            });
            if(selectedOption!='') select.value=selectedOption;

        }
    }
}

function precioProducto(e, id) {
    const url = base_url + 'compras/precioProducto/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            cargarDetalle();
            alertas(res.msg, res.icono);
        }
    }
}

function cantidadCompra(e, id) {
    const url = base_url + 'compras/cantidadCompra/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            if (res.icono != 'success') {
                alertas(res.msg, res.icono);
            }
            cargarDetalle();
            return;
        }
    }
}

function descuentoCompra(e, id) {
    const url = base_url + 'compras/descuentoCompra/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            cargarDetalle();
            alertas(res.msg, res.icono);
        }
    }
}

function deleteDetalle(id) {
    const url = base_url + "compras/delete/" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
        }
    }
}

function generarCompra() {
    Swal.fire({
        title: 'Esta seguro de procesar la Compra?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            let fila = document.querySelectorAll("#t_com tr").length;
            if (fila < 2) {
                alertas('No hay productos para proceder con la compra', 'warning');
                return;
/*            } else if (serie.value == '') {
                alertas('La serie es requerido', 'warning');
                return;*/
            } else {
                const url = base_url + 'compras/generar';
                const data = new FormData();
                data.append('id_proveedor', id_proveedor.value);
                const forma = (contado.checked ? 1 : 2);
                data.append('forma', forma);
                data.append('serie', serie.value);
                data.append('anotacion', anotacion.value);
                data.append('fecha', fecha.value);             

                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(data);
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        console.log(this.responseText);
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.folio) {
                            let ruta;
                            ruta = base_url + 'compras/generarPdf/' + res.folio;
                            window.open(ruta);
                            setTimeout(() => {
                                window.location.reload();
                            }, 2000);
                        }
                    }
                }
            }

        }
    })
}