let t_h_apart;
document.addEventListener('DOMContentLoaded', function () {
    //DataTables Historial Apartados - Ajax
    t_h_apart = $('#t_apartado_historial').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "apartados/listarApartados",
            "dataSrc": ""
        },

        "columns": [{
            "data": "id"
        },
        {
            "data": "total"
        },
        {
            "data": "nombre"
        },
        {
            "data": "fecha"
        },
        {
            "data": "fecha_recojo"
        },
        {
            "data": "estado"
        },
        {
            "data": "acciones"
        }
        ],
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ]
    });

    $('#min').change(function (e) {
        t_h_apart.draw();
    });
    //Busqueda por Rango de Fechas DataTables - Hasta
    $('#max').change(function (e) {
        t_h_apart.draw();
    }); 
})

function generarVenta(id) {
    Swal.fire({
        title: 'Que desea Hacer?',
        showCancelButton: true,
        confirmButtonText: `Generar venta`,
        cancelButtonText: `Cancelar`,
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + 'apartados/generarVenta/' + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    console.log(this.responseText);
                    const res = JSON.parse(this.responseText);
                    $('#verApartado').modal('hide');
                    alertas(res.msg, res.icono);
                    if (res.icono == 'success') {
                        const ruta = base_url + 'ventas/generarPdf/' + res.id_venta;
                        setTimeout(() => {
                            window.open(ruta);
                        }, 2000);
                    }
                    t_h_apart.ajax.reload();
                }
            }
        }
    })
}

function verApartado(id) {
    const url = base_url + 'apartados/verDetalle/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            document.getElementById('detalle_cliente').innerHTML = `
            <tr>
                <td>${res.apartado.nombre}</td>
                <td>${res.apartado.telefono}</td>
                <td>${res.apartado.direccion}</td>
            </tr>
            `;
            let html = '';
            res.productos.forEach(row => {
                html += `
                    <tr>
                        <td>${row.cantidad}</td>
                        <td>${row.descripcion}</td>
                        <td>${row.precio}</td>
                        <td>${row.descuento}</td>
                        <td>${row.sub_total}</td>
                    </tr>
                `;
            });
            document.getElementById('detalle_apart').innerHTML = html;
            document.getElementById('abonado').value = res.apartado.monto_abono;
            document.getElementById('apartado_total').value = res.total_apartado;
            document.getElementById('restante').value = parseFloat(res.total_apartado) - parseFloat(res.apartado.monto_abono);
            document.getElementById('fecha_recojo').textContent = res.apartado.fecha_recojo;
            document.getElementById('accionApart').innerHTML = `
                <button class="btn btn-primary" type="button" onclick="generarVenta(${res.apartado.id})"><i class="fas fa-print"></i> Procesar</button>
                <button class="btn btn-danger" type="button" data-dismiss="modal"><i class="fas fa-times-circle"></i> Cerrar</button>
                `;
            $('#verApartado').modal('show');
        }

    }
}