const year_chrats = document.getElementById('yearCharts');
const nombre_cliente = document.getElementById('nombreCliente');


const reporte_table = document.getElementById('reportetable');

let ventasChartObj=false;
let ventasChartCanvas=false;
let pagosChartObj=false;
let pagosChartCanvas=false;

let ventaspagosChartObj=false;
let ventaspagosChartCanvas=false;


let datosCharts={};

document.addEventListener('DOMContentLoaded', function(){

  btnReporteCli(idcliente)
})

function btnReporteCli(id)
{
  if(id===false) return;

  const url = base_url + 'vendedores/editar/' + id;
  const http = new XMLHttpRequest();
  http.open("GET", url, true);
  http.send();
  http.onreadystatechange = function () {
      if (this.readyState == 4 && this.status == 200) {
          const res = JSON.parse(this.responseText);
          
          nombre_cliente.innerHTML=`[${res.id}] ${res.nombre}`;
          iniciarReportes()
      }
  }    
}

function iniciarReportes()
{
    const anio = year_chrats.value;
    if(idcliente===false) return;
    const url = base_url + 'vendedores/comparacionVentasPagosMes/' + anio +'/'+ idcliente;

    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            datosCharts.pagos=res.pagos;
            datosCharts.ventas=res.ventas;

            actualizarGraficoVentasMesCliente();
            actualizarGraficoPagosMesCliente();
            actualizarGraficoVentasPagosMesCliente();   
            tableVentasPagos();
        }
    }
}

function actualizarGraficoVentasPagosMesCliente() {

    if(ventaspagosChartObj) { ventaspagosChartObj.destroy(); }

    ventaspagosChartCanvas = $('#comparacionVentasPagos').get(0).getContext('2d')

    var salesChartData = {
      labels: ['Enero', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
      datasets: [
        {
          label: 'Ventas',
          backgroundColor: 'rgba(220,53,69, 1)',
          borderColor: 'rgba(220,53,69, 1)',
          pointRadius: false,
          pointColor: 'rgba(220,53,69, 1)',
          pointStrokeColor: '#c1c7d1',
          pointHighlightFill: '#fff',
          pointHighlightStroke: 'rgba(220,220,220,1)',
          data: [datosCharts.ventas.ene, datosCharts.ventas.feb, datosCharts.ventas.mar, datosCharts.ventas.abr, datosCharts.ventas.may, datosCharts.ventas.jun, datosCharts.ventas.jul, datosCharts.ventas.ago, datosCharts.ventas.sep, datosCharts.ventas.oct, datosCharts.ventas.nov, datosCharts.ventas.dic],
        },
        {
          label: 'Pagos',
          backgroundColor: 'rgba(40,167,69,0.9)',
          borderColor: 'rgba(40,167,69,0.8)',
          pointRadius: false,
          pointColor: '#3b8bba',
          pointStrokeColor: 'rgba(40,167,69,1)',
          pointHighlightFill: '#fff',
          pointHighlightStroke: 'rgba(40,167,69,1)',                    
          data: [datosCharts.pagos.ene, datosCharts.pagos.feb, datosCharts.pagos.mar, datosCharts.pagos.abr, datosCharts.pagos.may, datosCharts.pagos.jun, datosCharts.pagos.jul, datosCharts.pagos.ago, datosCharts.pagos.sep, datosCharts.pagos.oct, datosCharts.pagos.nov, datosCharts.pagos.dic],
        }
      ]
    }
  
    var salesChartOptions = {
      maintainAspectRatio: false,
      responsive: true,
      legend: {
        display: false
      },
      scales: {
        xAxes: [{
          gridLines: {
            display: false
          }
        }],
        yAxes: [{
          gridLines: {
            display: false
          }
        }]
      }
    }
  
    // This will get the first returned node in the jQuery collection.
    // eslint-disable-next-line no-unused-vars
    ventaspagosChartObj = new Chart(ventaspagosChartCanvas, {
      type: 'line',
      data: salesChartData,
      options: salesChartOptions
    }
    )

}

function actualizarGraficoPagosMesCliente() {
   
    if(pagosChartObj) { pagosChartObj.destroy(); }

    pagosChartCanvas = $('#comparacionPagos').get(0).getContext('2d') 

    var salesChartData = {
        labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        datasets: [
          {
            label: 'Pagos',
            backgroundColor: 'rgba(247,222,97,0.9)',
            borderColor: 'rgba(247,222,97,0.8)',
            pointRadius: false,
            pointColor: '#3b8bba',
            pointStrokeColor: 'rgba(247,222,97,1)',
            pointHighlightFill: '#fff',
            pointHighlightStroke: 'rgba(247,222,97,1)',
            data: [datosCharts.pagos.ene, datosCharts.pagos.feb, datosCharts.pagos.mar, datosCharts.pagos.abr, datosCharts.pagos.may, datosCharts.pagos.jun, datosCharts.pagos.jul, datosCharts.pagos.ago, datosCharts.pagos.sep, datosCharts.pagos.oct, datosCharts.pagos.nov, datosCharts.pagos.dic],
          }
        ]
      }
    
      var salesChartOptions = {
        maintainAspectRatio: false,
        responsive: true,
        legend: {
          display: false
        },
        scales: {
          xAxes: [{
            gridLines: {
              display: false
            }
          }],
          yAxes: [{
            gridLines: {
              display: false
            }
          }]
        }
      }
    
      // This will get the first returned node in the jQuery collection.
      // eslint-disable-next-line no-unused-vars
      pagosChartObj = new Chart(pagosChartCanvas, {
        type: 'bar',
        data: salesChartData,
        options: salesChartOptions
      }
      )

}

function actualizarGraficoVentasMesCliente() {

    if(ventasChartObj) { ventasChartObj.destroy(); }

    ventasChartCanvas = $('#comparacionVentas').get(0).getContext('2d') 

            datosCharts.ventas;

            var salesChartData = {
                labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                datasets: [
                  {
                    label: 'Ventas',
                    backgroundColor: 'rgba(247,222,97,0.9)',
                    borderColor: 'rgba(247,222,97,0.8)',
                    pointRadius: false,
                    pointColor: '#3b8bba',
                    pointStrokeColor: 'rgba(247,222,97,1)',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(247,222,97,1)',
                    data: [datosCharts.ventas.ene, datosCharts.ventas.feb, datosCharts.ventas.mar, datosCharts.ventas.abr, datosCharts.ventas.may, datosCharts.ventas.jun, datosCharts.ventas.jul, datosCharts.ventas.ago, datosCharts.ventas.sep, datosCharts.ventas.oct, datosCharts.ventas.nov, datosCharts.ventas.dic],
                  }
                ]
              }
            
              var salesChartOptions = {
                maintainAspectRatio: false,
                responsive: true,
                legend: {
                  display: false
                },
                scales: {
                  xAxes: [{
                    gridLines: {
                      display: false
                    }
                  }],
                  yAxes: [{
                    gridLines: {
                      display: false
                    }
                  }]
                }
              }
            
              // This will get the first returned node in the jQuery collection.
              // eslint-disable-next-line no-unused-vars
              ventasChartObj = new Chart(ventasChartCanvas, {
                type: 'bar',
                data: salesChartData,
                options: salesChartOptions
              }
              )

}

function tableVentasPagos()
{
         let total_ventas=sumObj(datosCharts.ventas);
         let total_pagos=sumObj(datosCharts.pagos);

         reporte_table.innerHTML=`
         <tr><th scope="row">Enero</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.ene)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.ene)}</td></tr>
         <tr><th scope="row">Febrero</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.feb)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.feb)}</td></tr>
         <tr><th scope="row">Marzo</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.mar)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.mar)}</td></tr>
         <tr><th scope="row">Abril</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.abr)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.abr)}</td></tr>
         <tr><th scope="row">Mayo</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.may)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.may)}</td></tr>
         <tr><th scope="row">Junio</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.jun)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.jun)}</td></tr>
         <tr><th scope="row">Julio</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.jul)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.jul)}</td></tr>
         <tr><th scope="row">Agosto</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.ago)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.ago)}</td></tr>
         <tr><th scope="row">Septiembre</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.sep)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.sep)}</td></tr>
         <tr><th scope="row">Octubre</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.oct)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.oct)}</td></tr>
         <tr><th scope="row">Noviembre</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.nov)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.nov)}</td></tr>
         <tr><th scope="row">Diciembre</th><td class='text-right'>Q.${numFormat(datosCharts.ventas.dic)}</td><td class='text-right'>Q.${numFormat(datosCharts.pagos.dic)}</td></tr>
         <tr><th scope="row">TOTAL</th><th class='text-right'>Q.${numFormat(total_ventas)}</th><th class='text-right'>Q.${numFormat(total_pagos)}</th></tr>`

}

function numFormat(num) {
    return new Intl.NumberFormat("gt-GT").format(num)
}

function sumObj(obj) {
    return Object.keys(obj).reduce((acc, key) => acc + parseFloat(obj[key] || 0), 0);
}