<?php

class Clientes extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        parent::__construct();
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    public function index()
    {
        $id_usuario = $_SESSION['id_usuario'];
        $data['vendedores'] = $this->model->getVendedoresClientes($id_usuario);

        $data['scripts'] = array(
            array('script' => 'moment.min.js'),         
            array('script' => 'chart.min.js'),
            array('script' => 'pages/clientes.js'),
        );
        $this->views->getView('clientes', "index", $data);
    }

    public function dashboard($datos)
    {
        $data['idcliente']=$datos;
        $data['scripts'] = array(
            array('script' => 'moment.min.js'),         
            array('script' => 'chart.min.js'),
            array('script' => 'helpers.js'),       
            array('script' => 'pages/clientesreportesdashboard.js'),
        );
        $this->views->getView('clientes', "dashboard", $data);
    }

    public function dashboardventas($datos)
    {
        $data['idcliente']=$datos;
        $data['cliente'] = $this->model->getNombreCliente($data['idcliente']);
        $data['categorias'] = $this->model->getCategorias();
        
        
        $data['scripts'] = array(
            array('script' => 'moment.min.js'),         
            array('script' => 'chart.min.js'),           
            array('script' => 'pages/clientesreportes.js'),
        );
        $this->views->getView('clientes', "dashboardventas", $data);
    }


    public function dashboardvisitas($datos)
    {
        $data['idcliente']=$datos;
        $data['cliente']=$this->model->getNombreCliente($data['idcliente']);
        $data['scripts'] = array(
            array('script' => 'moment.min.js'),         
            array('script' => 'chart.min.js'),           
            array('script' => 'pages/clientesreportesvisitas.js'),
        );
        $this->views->getView('clientes', "dashboardvisitas", $data);
    }
    
  
    public function comparacionVisitasMes($datos)
    {
        list($anio,$cliente)=explode(',', $datos);
        $data['visitas'] = $this->model->getVisitasMes($anio,$cliente);
        $data['visitasGroup'] = $this->model->getVisitasMesGroup($anio,$cliente);
        
        //var_dump($data);

        echo json_encode($data);
        
        
        die();
    }


    public function reporteVentasCliente($datos)
    {
        list($anio,$cliente)=explode(',', $datos);
        $data['categorias'] = $this->model->comparacionClienteCategorias($anio,$cliente);
        $data['productos'] = $this->model->comparacionClienteProductos($anio,$cliente);
        $data['cliente'] = $this->model->comparacionClienteDatos($anio,$cliente);
        
        echo json_encode($data);
        die();
    }

    public function reportePagos($datos)
    {
        list($anio,$cliente)=explode(',', $datos);
        $data['pagos'] = $this->model->comparacionPagos($anio,$cliente);
        echo json_encode($data);
        die();
    }

    public function reporteFacturas($datos)
    {
        list($anio,$cliente)=explode(',', $datos);
        $data['facturas'] = $this->model->comparacionFacturas($anio,$cliente);
        echo json_encode($data);
        die();
    }

    public function comparacionVentasPagosMes($datos)
    {
        list($anio,$cliente)=explode(',', $datos);
        $desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';
        $data['ventas'] = $this->model->comparacionVentasMes($desde, $hasta, $cliente);
        $data['pagos'] = $this->model->comparacionPagosMes($desde, $hasta, $cliente);
        echo json_encode($data);
        die();
    }

    public function comparacionVentasMes($datos)
    {
        list($anio,$cliente)=explode(',', $datos);
        $desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';

        $data['ventas'] = $this->model->comparacionVentasMes($desde, $hasta, $cliente);
        echo json_encode($data);
        die();
    }

    public function comparacionPagosMes($datos)
    {
        list($anio,$cliente)=explode(',', $datos);
        $desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';

        $data['pagos'] = $this->model->comparacionPagosMes($desde, $hasta, $cliente);
        echo json_encode($data);
        die();
    }

    public function listar()
    {
        /*$locale = 'es_ES';
        $dateType = IntlDateFormatter::MEDIUM;
        $timeType = IntlDateFormatter::NONE;
        $timeType2 = IntlDateFormatter::MEDIUM;
        $timezone = date_default_timezone_get();
        $dateFormatter = new IntlDateFormatter( $locale, $dateType, $timeType, $timezone );
        $dateFormatterTime = new IntlDateFormatter( $locale, $dateType, $timeType2, $timezone );*/

        $id_usuario = $_SESSION['id_usuario'];
        $data = $this->model->getClientes($id_usuario);

        foreach($data as $key=>$value)
        {
            $data[$key]['ultimaventa_search']=$data[$key]['ultimaventa'];
            $data[$key]['ultimopago_search']=$data[$key]['ultimopago'];
            $data[$key]['programacion_search']=$data[$key]['programacion'];
            $data[$key]['ultimavisita_search']=$data[$key]['ultimavisita'];

            /*$data[$key]['ultimaventa_format']=$dateFormatter->format(strtotime($data[$key]['ultimaventa']));
            $data[$key]['ultimopago_format']=$dateFormatter->format(strtotime($data[$key]['ultimopago']));
            $data[$key]['programacion_format']=$dateFormatter->format(strtotime($data[$key]['programacion']));
            $data[$key]['ultimavisita_format']=$dateFormatterTime->format(strtotime($data[$key]['ultimavisita']));*/
            //$data[$key]['nombre']=iso8859_to_utf8($data[$key]['nombre']);
        }

        //echo json_encode($data, JSON_UNESCAPED_UNICODE);
        echo json_encode($data, JSON_INVALID_UTF8_IGNORE);
        
        die();
    }


    public function registrarVisita($data)
    {
        $datos=explode('|',$data);
        $id=$datos[3];
        $id_vendedor1=$datos[4];
        $codcliente=$datos[5];

        $coords=$datos[0].'|'.$datos[1].'|'.$datos[2];

        $data = $this->model->guardarVisita($codcliente,$coords,$id_vendedor1);

        echo json_encode([], JSON_UNESCAPED_UNICODE);
        die();
    }
    
    public function editarAnotacionesVisitas()
    {
        $id = strClean($_POST['id']);
        $observaciones = $_POST['salidaaudio'];
        $coordenadas = $_POST['coordenadas'];

        $data = $this->model->modificarAnotacionesVisitas($observaciones, $id, $coordenadas);
        if ($data == "modificado") {
            $msg = array('msg' => 'Anotación modificada con exito', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al modificar la anotación', 'icono' => 'error');
        }

        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function editarAnotaciones()
    {
        $id = strClean($_POST['id']);
        $observaciones = $_POST['observaciones'];
        
        $data = $this->model->modificarAnotaciones($observaciones, $id);

        if ($data == "modificado") {
            $msg = array('msg' => 'Anotación modificada con exito', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al modificar la anotación', 'icono' => 'error');
        }

        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function editarProgramacion()
    {
        $id = strClean($_POST['id']);
        $fecha = $_POST['fecha'];
        $codcliente=$_POST['codigo'];
        $id_vendedor1=$_POST['vendedor'];
        $nomcliente=$_POST['nombre'];
        
        $data = $this->model->modificarProgramacion($fecha, $id,$codcliente,$nomcliente,$id_vendedor1);

        $msg = array('msg' => 'Programación modificada', 'icono' => 'success');
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function editarCobro()
    {
        $id = strClean($_POST['id']);
        $fecha = $_POST['fecha'];
        $codcliente=$_POST['codigo'];
        $id_vendedor1=$_POST['vendedor'];
        $nomcliente=$_POST['nombre'];
        
        $data = $this->model->modificarCobro($fecha, $id,$codcliente,$nomcliente,$id_vendedor1);

        $msg = array('msg' => 'Cobro Agregado', 'icono' => 'success');
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function editarLlamada()
    {
        $id = strClean($_POST['id']);
        $fecha = $_POST['fecha'];
        $codcliente=$_POST['codigo'];
        $id_vendedor1=$_POST['vendedor'];
        $nomcliente=$_POST['nombre'];
        
        $data = $this->model->modificarLlamada($fecha, $id,$codcliente,$nomcliente,$id_vendedor1);

        $msg = array('msg' => 'Llamada Agregada', 'icono' => 'success');
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }


    function isValidDate($dateString, $format = 'Y-m-d') {
        $dateTime = DateTime::createFromFormat($format, $dateString);
        return $dateTime && $dateTime->format($format) === $dateString;
    }    

    public function registrar()
    {
        $nombre = strClean($_POST['nombre']);
        $telefono = strClean($_POST['telefono']);
        $mensajeria = strClean($_POST['mensajeria']);
        $tipoid = strClean($_POST['tipoid']);                
        $nit = strClean($_POST['nit']);        
        $direccion = strClean($_POST['direccion']);
        $municipio = strClean($_POST['municipio']);
        $departamento = strClean($_POST['departamento']);
        $pais = strClean($_POST['pais']);
        $coordenadas = strClean($_POST['coordenadas']);

        $limite_credito = strClean($_POST['limite_credito']);
        $dias_credito = strClean($_POST['dias_credito']);
        $id_vendedor1 = strClean($_POST['id_vendedor1']);
        $tipocliente = strClean($_POST['tipocliente']);

        $contacto = strClean($_POST['contacto']);
        $telcontacto = strClean($_POST['telcontacto']);
        
        $observaciones = $_POST['observaciones'];


        $id = strClean($_POST['id']);
        if (empty($nombre) || empty($telefono) || empty($direccion)) {
            $msg = array('msg' => 'Todo los campos son obligatorios', 'icono' => 'error');
        } else {
            if ($id == "") {
                $data = $this->model->registrarCliente($nombre, $tipoid, $nit, $telefono, $mensajeria, $direccion, $municipio, $departamento, $pais, $coordenadas, $limite_credito, $dias_credito, $id_vendedor1, $tipocliente, $contacto, $telcontacto, $observaciones);
                if ($data == "ok") {
                    $msg = array('msg' => 'Cliente registrado', 'icono' => 'success');
                } else if ($data == "existe") {
                    $msg = array('msg' => 'El cliente ya existe', 'icono' => 'warning');
                } else {
                    $msg = array('msg' => 'Error al registrar el cliente', 'icono' => 'error');
                }
            } else {
                $data = $this->model->modificarCliente($nombre, $tipoid, $nit, $telefono,$mensajeria, $direccion, $municipio, $departamento, $pais, $coordenadas, $limite_credito, $dias_credito, $id_vendedor1, $tipocliente, $contacto, $telcontacto, $observaciones, $id);
                if ($data == "modificado") {
                    $msg = array('msg' => 'Cliente modificado con éxito', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al modificar el cliente', 'icono' => 'error');
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function insertar()
    {
        $data['vendedores']=$this->model->getVendedores();
        $data['paises']=$this->model->getPaises();
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function editar(int $id)
    {
        $data = $this->model->editarCli($id);
        $data['facturas_vencidas'] = $this->model->verficarFacturasVencidas($id,$data['dias_credito']);
        $data['visita'] = $this->model->ultimaVisita($id);

        $data['vendedores']=$this->model->getVendedores();
        $data['paises']=$this->model->getPaises();
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function generarReporteEstadoCuenta($id)
    {
        $data['cliente'] = $this->model->editarCli($id);
        $data['empresa'] = $this->model->getEmpresa();
        $data['detalle'] = $this->model->getReporteEstadoCuenta($id);
        
        ob_start();
        $html = $this->views->getView('clientes', "reporteestadocuenta", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        if ($data['compra']['estado'] == 0) {
            $mpdf->SetWatermarkImage('Assets/img/anulado.png');
            $mpdf->showWatermarkImage = true;
        }

        $mpdf = new \Mpdf\Mpdf([]);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }
    
    public function generarReporteAntiguedadSaldos($id)
    {
        if((int)$id!==0) $data['cliente'] = $this->model->editarCli($id);
        $data['empresa'] = $this->model->getEmpresa();
        $data['detalle'] = $this->model->getReporteAntiguedadSaldos($id);

        ob_start();
        $html = $this->views->getView('clientes', "reporteantiguedadsaldos", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([]);
        $mpdf->WriteHTML($html);
        $mpdf->Output('Antiguedad_saldos.pdf', 'I');
    }

    public function generarReporteCuentasCobrar($id)
    {
        if((int)$id!==0) $data['cliente'] = $this->model->editarCli($id);
        $data['empresa'] = $this->model->getEmpresa();
        $data['detalle'] = $this->model->getReporteCuentasCobrar($id);

        ob_start();
        $html = $this->views->getView('clientes', "reportecuentascobrar", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([]);
        $mpdf->WriteHTML($html);
        $mpdf->Output('Cuentas_cobrar.pdf', 'I');
    }
       

    public function eliminar(int $id)
    {
        $data = $this->model->accionCli(0, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Cliente dado de baja', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar el cliente', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    
    public function reingresar(int $id)
    {
        $data = $this->model->accionCli(1, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Cliente reingresado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al reingresar el cliente', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function buscarCliente()
    {
        $data = $this->model->buscarCliente($_GET['q']);
        $datos = array();
        foreach ($data as $row) {
            $data['id'] = $row['id'];
            $data['label'] = $row['nombre'] . ' - ' . $row['direccion'];
            $data['value'] = $row['nombre'];
            $data['vendedor'] = $row['id_vendedor1'];
            $data['tipoid'] = $row['tipoid'];
            $data['nit'] = $row['nit'];         
            $data['direccion'] = $row['direccion'];
            array_push($datos, $data);
        }
        echo json_encode($datos, JSON_UNESCAPED_UNICODE);
        die();
    }


}
