<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="<?php echo base_url . 'Assets/css/reporte.css'; ?>">
</head>

<body>
    <table id="datos-empresa">
        <tr>
            <td class="logo">
                <img src="<?php echo base_url . 'Assets/img/logo.png'; ?>" alt="" width="150">
            </td>
            <td class="info-empresa">
                <p><b><?php echo $data['empresa']['nombre']; ?></b></p>
            </td>
        </tr>
    </table>

    <h2 style='text-align:center;'>ANTIGÜEDAD DE SALDOS</h2>

    <? if((int)$data['cliente']['id']!==0) { ?>
        <P>
            <strong>CLIENTE:</strong> <?php echo $data['cliente']['id'] ?><br/>
            <strong>NOMBRE:</strong> <?php echo $data['cliente']['nombre'] ?>
        </P>
    <? } ?>

    <table cellspacing=0>
        <thead>
            <tr>
                <th class="text-right">FACTURA</th>
                <th class="text-left">FECHA</th>
                <th class="text-right">VENCE</th>
                <th class="text-right">SALDO</th>
                <th class="text-right">30 DÍAS</th>
                <th class="text-right">60 DÍAS</th>
                <th class="text-right">90 DÍAS+</th>
            </tr>
            <tr class='blanco'>
                <th colspan='7'>&nbsp;</th>
            </tr>            
        </thead>
        <tbody>
            <?php
            $total_saldo = 0;
            $total_30 = 0;
            $total_60 = 0;
            $total_90 = 0;
            $primero=true;

            $total_saldo_general = 0;
            $total_30_general = 0;
            $total_60_general = 0;
            $total_90_general = 0;

            $idcliente=false;
            $cambio_cliente=false;            

            foreach ($data['detalle'] as $producto) {

                if($idcliente!=$producto['IDCLIENTE'])
                {
                    $idcliente=$producto['IDCLIENTE'];
                    $cambio_cliente=true;
                }

                if($cambio_cliente===true && (int)$data['cliente']['id']===0)
                {
                    
                    if($primero===false)
                    {
                        ?>
                            <tr>
                                <th class="text-right fborder" colspan=3>TOTAL CLIENTE</th>
                                <th class="text-right fborder"><?php echo number_format($total_saldo,2,'.',','); ?></th>
                                <th class="text-right fborder"><?php echo number_format($total_30,2,'.',','); ?></th>
                                <th class="text-right fborder"><?php echo number_format($total_60,2,'.',','); ?></th>
                                <th class="text-right fborder"><?php echo number_format($total_90,2,'.',','); ?></th>
                            </tr>
                        <?
                    }
                    ?>
                        <tr>
                            <th colspan='7' class='text-left'><?php echo "[{$producto['IDCLIENTE']}] {$producto['CLIENTE']}"; ?></th>
                        </tr>
                    <?

                    $total_saldo = 0;
                    $total_30 = 0;
                    $total_60 = 0;
                    $total_90 = 0;                
                }

                $total_saldo += $producto['SALDO'];
                $total_30    += $producto['30'];
                $total_60    += $producto['60'];
                $total_90    += $producto['90'];

                $total_saldo_general += $producto['SALDO'];
                $total_30_general    += $producto['30'];
                $total_60_general    += $producto['60'];
                $total_90_general    += $producto['90'];

                ?>
                <tr>
                    <td class="text-right"><?php echo $producto['FACTURA']; ?></td>
                    <td><?php echo date('d/m/Y', strtotime($producto['FECHA'])); ?></td>
                    <td><?php echo date('d/m/Y', strtotime($producto['VENCE'])); ?></td>
                    <td class="text-right"><?php echo number_format($producto['SALDO'],2,'.',',');; ?></td>
                    <td class="text-right"><?php echo number_format($producto['30'],2,'.',',');; ?></td>
                    <td class="text-right"><?php echo number_format($producto['60'],2,'.',',');; ?></td>
                    <td class="text-right"><?php echo number_format($producto['90'],2,'.',',');; ?></td>
                </tr>
                <?php 
                    $cambio_cliente=false;
                    $primero=false;
                }
                ?>
                
                <? if((int)$data['cliente']['id']===0) { ?>
                <tr>
                    <th class="text-right fborder" colspan=3>TOTAL CLIENTE</th>
                    <th class="text-right fborder"><?php echo number_format($total_saldo,2,'.',','); ?></th>
                    <th class="text-right fborder"><?php echo number_format($total_30,2,'.',','); ?></th>
                    <th class="text-right fborder"><?php echo number_format($total_60,2,'.',','); ?></th>
                    <th class="text-right fborder"><?php echo number_format($total_90,2,'.',','); ?></th>
                </tr>
                <? } ?>


        </tbody>
        <tfoot>
            <tr>
                <th></th>
                <th></th>
                <th></th>
                <th class="text-right fborder"><?php echo number_format($total_saldo_general,2,'.',','); ?></th>
                <th class="text-right fborder"><?php echo number_format($total_30_general,2,'.',','); ?></th>
                <th class="text-right fborder"><?php echo number_format($total_60_general,2,'.',','); ?></th>
                <th class="text-right fborder"><?php echo number_format($total_90_general,2,'.',','); ?></th>
            </tr>
            <tr>
                <th colspan='3'></th>
                <th class="text-right fdborder" colspan='4'>&nbsp;</th>
            </tr>            
        </tfoot>
    </table>

</body>

</html>

<style type='text/css'>
THEAD TR TH {
    background: #ccc;
    border-top: 1px solid #000;
    padding-left:5mm;
    padding-right:5mm;
    font-size:3mm;
}


THEAD TR.blanco TH {
    background: #fff;
    border-bottom: 1px solid #000;
    height:2px;
    font-size:2px;
    line-height:2px;
}
.text-left { text-align:left; }
.text-right { text-align:right; }
TBODY TR TD {
    font-size:3mm;
    padding-top:0.5mm;
    padding-bottom:0.5mm;
    padding-left:5mm;
    padding-right:5mm;
}
TBODY TR TH {
    font-size:3mm;
    padding-top:0.5mm;
    padding-bottom:0.5mm;
    padding-left:5mm;
    padding-right:5mm;
    border-top:1px solid #000;
    border-bottom:1px solid #000;
}
TFOOT TR TH {
    padding-left:5mm;
    padding-right:5mm;
    font-size:3mm;
}
TFOOT TR TH.fborder {
    border-top: 1px solid #000;
    background: #ccc;
}
TFOOT TR TH.fdborder {
    border-top: 1px solid #000;
    border-bottom: 1px solid #000;
    height:2px;
    font-size:2px;
    line-height:2px;
}
</style>