const retiro = document.getElementById("retiro");
const monto_abono = document.getElementById("monto_abono");
const nota = document.getElementById("nota");
const id_cliente = document.getElementById("id_cliente");
const btnAccion = document.getElementById('btnAccion');
document.addEventListener('DOMContentLoaded', function () {
    cargarDetalle();

    //Autocomplete - Jquery UI, Buscar Productos para apartar productos
    $("#buscarApartado").autocomplete({
        minLength: 2,
        source: function (request, response) {
            $.ajax({
                url: base_url + 'cotizaciones/buscarProducto',
                dataType: "json",
                data: {
                    pro: request.term
                },
                success: function (data) {
                    if (data.length > 0) {
                        response(data);
                    } else {
                        document.getElementById('error_producto').textContent = 'No hay Producto Similar';
                    }
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('error_producto').textContent = '';
            const id_pro = ui.item.id;
            ingresarApartado(id_pro);
        }
    })

    btnAccion.addEventListener('click', apartar);
})

function ingresarApartado(id_pro) {
    const url = base_url + 'apartados/registrarApartado/' + id_pro;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
            document.getElementById('buscarApartado').value = '';
            document.getElementById('buscarApartado').focus();
            return;
        }
    }
}
function cantidad(e, id) {
    const url = base_url + 'apartados/cantidad/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            if (res.icono != 'success') {
                alertas(res.msg, res.icono);
            }
            cargarDetalle();
            return false;
        }
    }
}
function cargarDetalle() {
    const url = base_url + 'apartados/listar';
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            let html = '';
            res.detalle.forEach(row => {
                html += `<tr>
               <td>${row['descripcion']}</td>
               <td width="150">
               <input type="number" class="form-control" min="1" value="${row['cantidad']}" onchange="cantidad(event, ${row['id']})">
               </td>
               <td width="150">
               <input type="number" class="form-control" step="0.01" min="0.01" value="${row['descuento']}" onchange="descuento(event, ${row['id']})">
               </td>
               <td>${row['precio']}</td>
               <td>${row['sub_total']}</td>
               <td>
               <button class="btn btn-danger" type="button" onclick="eliminar(${row['id']})">
               <i class="fas fa-trash-alt"></i></button>
               </td>
               </tr>`;
            });
            document.getElementById("t_apartados").innerHTML = html;
            document.getElementById("total").value = res.total_pagar.total;
        }
    }
}
function descuento(e, id) {
    const url = base_url + 'apartados/descuento/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
            return false;
        }
    }
}
function eliminar(id) {
    const url = base_url + "apartados/delete/" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
        }
    }
}
function apartar(e) {
    e.preventDefault();
    Swal.fire({
        title: 'Esta seguro de procesar?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            let fila = document.querySelectorAll("#t_apartados_hist tr").length;
            if (fila < 2) {
                alertas('No hay productos en la tabla', 'warning');
                return false;
            } else {

                if (retiro.value == '' || monto_abono.value == '' || nota.value == '' || id_cliente.value == '') {
                    alertas('Todo los campos con * son obligatorios', 'warning');
                    return false;
                } else {
                    const url = base_url + 'apartados/apartarProducto';
                    const data = new FormData();
                    data.append('retiro', retiro.value);
                    data.append('monto_abono', monto_abono.value);
                    data.append('nota', nota.value);
                    data.append('id_cliente', id_cliente.value);
                    const http = new XMLHttpRequest();
                    http.open("POST", url, true);
                    http.send(data);
                    http.onreadystatechange = function () {
                        if (this.readyState == 4 && this.status == 200) {
                            const res = JSON.parse(this.responseText);
                            alertas(res.msg, res.icono);
                            if (res.folio) {
                                const ruta = base_url + 'apartados/pdfApartado/' + res.folio;
                                window.open(ruta)
                                setTimeout(() => {
                                    cargarDetalle();
                                    document.getElementById('id_cliente').value = '';
                                    frm.reset();
                                }, 300);
                            }
                        }
                    }
                }
            }

        }
    })
}