let fecha_inicio = document.getElementById('fecha_desde');
let fecha_fin = document.getElementById('fecha_hasta');
let content_actividad = document.getElementById('content_actividad');
let mostrar = false;

const currencyFormatter = new Intl.NumberFormat('es-GT', {
  style: 'currency', // Specify currency formatting
  currency: 'GTQ',   // Specify the ISO currency code for Quetzal
  minimumFractionDigits: 2 // Optional: ensure at least 2 decimal places
});

const optionsDate = { year: 'numeric', month: 'short' , day: 'numeric', hour: '2-digit', minute: '2-digit', second: '2-digit', timeZone: 'America/Guatemala' };

document.addEventListener('DOMContentLoaded', function(){
    initfechascomparacion()
    cargarActividad()
})


function ocultarMostrar() {
    document.querySelectorAll('.detalleActividad').forEach(row => {
        if (mostrar===true) {
          row.classList.remove('d-none');
        } else {
          row.classList.add('d-none');          
        }
    });
    mostrar=!mostrar;
}


function initfechascomparacion()
{
    fecha_inicio.value=moment().format('YYYY-MM-DD');
    fecha_fin.value=moment().format('YYYY-MM-DD');
}

function cargarActividad() {

  const url = base_url + 'crm/getActividad/'+fecha_inicio.value+'/'+fecha_fin.value;
  pinButton=[];
  const http = new XMLHttpRequest();
  http.open("GET", url, true);
  http.send();
  http.onreadystatechange = function () {
      if (this.readyState == 4 && this.status == 200) {
          const res = JSON.parse(this.responseText);

          if(res.length == 0){
              content_actividad.innerHTML = `<div class="alert alert-warning mb-0">No hay actividad para mostrar</div>`
              console.log('No hay actividad para mostrar')
              return;
          } else {
            content_actividad.innerHTML= ``
            for (const key in res) {
              createActivity(key, vendedores[key], res[key])
            }
          }
      }
  }
}

function btnVervisitaCli(id) {
    const url = base_url + 'crm/verVisita/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            console.clear();
            console.table(res);

            let params = res.coordenadas.split('|');

            let lat=Number( params[1] );
            let lng=Number( params[2] );
            let paramse = res.coordenadas.split('|');
            let lat_entrada=Number( paramse[1] );
            let lng_entrada=Number( paramse[2] );

            $('#coordenadas_ultima_visita_entrada').html(`<span class="badge badge-warning ml-2">Latitud</span> ${lat_entrada} <span class="badge badge-warning ml-2">Longitud</span> ${lng_entrada} <span class="badge badge-warning ml-2">Fecha</span> ${res.fecha}`); 

            $('#coordenadas_cliente').html(res.nombre);

            if(res.anotaciones===null || res.anotaciones==='') {
                $('#observaciones_visita').html(`<span class="text-muted">Sin observaciones</span>`);
            } else {
                $('#observaciones_visita').html(res.anotaciones);
            }

            if(res.fecha_salida===null) {
                $('#coordenadas_ultima_visita_salida').html(`<span class="text-muted ml-2">Sin salida</span>`);
            } else {
                let paramss = res.coordenadas_salida.split('|');
                let lat_salida=Number( paramss[1] );
                let lng_salida=Number( paramss[2] );

                $('#coordenadas_ultima_visita_salida').html(`<span class="badge badge-warning ml-2">Latitud</span> ${lat_salida} <span class="badge badge-warning ml-2">Longitud</span> ${lng_salida} <span class="badge badge-warning ml-2">Fecha</span> ${res.fecha_salida}`);
            }

            if(isNaN(lat)===true || isNaN(lng)===true)
            {
                alertas('No tiene coordenadas definidas', 'danger');
            } else {
                $('#modal_map').modal('show');

                map = new google.maps.Map(document.getElementById("googleMap"),{
                    center:new google.maps.LatLng(lat, lng),
                    zoom:14,
                });

                marker = new google.maps.Marker({
                    position: { lat: lat, lng:lng  },
                    map: map,
                    title: res.nombre,
                });

            }
        }
    }
}

function error(msg) {
    s.innerHTML = typeof msg == 'string' ? msg : "failed";
    s.className = 'fail';
    console.log(msg)
}

/*window.onload = function() {
    btnVervisitaCli(1726)
};*/

function createActivity(key, vendedor, actividad) {
  
    let actividad_key = key;

    let actividad_html = ``
    let total_ventas = 0;
    let total_cobros = 0;
    let counter_ventas = 0;
    let counter_cobros = 0;
    let counter_programaciones = 0;
    let counter_visitas = 0;

    let counter_cumplimiento = 0;
    let counter_efectividad = 0;

    for (const key in actividad) {
        const act = actividad[key];

        let class_actividad='';
        let class_detalle='';

        if(act.sigla=='P'){
          class_actividad='table-success';
          class_detalle='badge badge-success border border-secondary';          
          act.detalles=`${new Date(act.detalles).toLocaleDateString('es-ES', optionsDate)}`
          link_detalle =``;
          counter_programaciones++;
        } else if(act.sigla=='V'){
          link_detalle =`onclick='btnVervisitaCli(${act.id})' style='cursor: pointer;'`;
          class_actividad='table-info';
          class_detalle='badge badge-primary border border-secondary';                    
          act.detalles=`${new Date(act.detalles).toLocaleDateString('es-ES', optionsDate)}`
          counter_visitas++;
        } else if(act.sigla=='VE'){ 
          class_actividad='table-warning';
          class_detalle='badge badge-warning border border-secondary';                    
          act.detalles=`#${act.detalles}<br/>${new Date(act.fecha).toLocaleDateString('es-ES', optionsDate)}<br>${currencyFormatter.format(Number(act.total))}<br><a ${link_detalle} class="badge badge-light border border-primary">${(act.enc_estado)}</a>`
          total_ventas += Number(act.total);
          link_detalle =`href='${base_url}pedidos/generarPdf/${act.id}' target='_blank'`;
          counter_ventas++;
        } else if(act.sigla=='CT'){ 
          class_actividad='table-warning';
          class_detalle='badge badge-info border border-secondary';                    
          act.detalles=`#${act.detalles}<br/>${new Date(act.fecha).toLocaleDateString('es-ES', optionsDate)}<br>${currencyFormatter.format(Number(act.total))}`
          //total_ventas += Number(act.total);
          link_detalle =`href='${base_url}pedidos/generarPdf/${act.id}' target='_blank'`;
          counter_ventas++;
        } else if(act.sigla=='PE'){ 
          class_actividad='table-warning';
          class_detalle='badge badge-secondary border border-secondary';                    
          act.detalles=`#${act.detalles}<br/>${new Date(act.fecha).toLocaleDateString('es-ES', optionsDate)}<br>${currencyFormatter.format(Number(act.total))}`
          //total_ventas += Number(act.total);
          link_detalle =`href='${base_url}pedidos/generarPdf/${act.id}' target='_blank'`;
          counter_ventas++;
        } else if(act.sigla=='C'){ 
          class_actividad='table-danger';
          class_detalle='badge badge-danger border border-secondary';                    
          act.detalles=`#${act.detalles}<br/>${new Date(act.fecha).toLocaleDateString('es-ES', optionsDate)}<br>${currencyFormatter.format(Number(act.total))}`
          total_cobros += Number(act.total);
          link_detalle =`href='${base_url}creditoventas/generarPdf/${act.id}' target='_blank'`;
          counter_cobros++;
        }

        actividad_html += `<tr class="${class_actividad} text-dark" style='font-size:0.8em;line-height:1.2em;'>
            <td><a ${link_detalle} class="${class_detalle}">${act.actividad}</a></td>
            <td>[${act.codcli}] ${act.nombre}</td>
            <td style='white-space: nowrap;'>${act.detalles}</td>
          </tr>`
    }

    if (counter_programaciones == 0) {
      counter_cumplimiento = 0;
    } else {
      counter_cumplimiento = Math.round((counter_visitas / counter_programaciones) * 100); // 2x100    / 1
    }
    if(counter_cumplimiento > 100) { counter_cumplimiento = 100; }
    if(counter_cumplimiento < 0) { counter_cumplimiento = 0; }
    
    if (counter_ventas == 0) {
      counter_efectividad = 0;
    } else {
      counter_efectividad = Math.round((counter_ventas / counter_visitas) * 100);
    }
    if(counter_efectividad > 100) { counter_efectividad = 100; }
    if(counter_efectividad < 0) { counter_efectividad = 0; }

    if (vendedor !== undefined) {
      content_actividad.innerHTML += `
              <div class="col-lg-4 col-md-6 col-sm-12">
                <div class="card card-success">
                  <div class="card-header border-info fw-bold p-2">
                    <div class='d-flex align-items-center justify-content-between'>
                        <img class="img-thumbnail mr-1" src="${base_url}Assets/img/usuarios/01-02.png" width="35">
                        <span class='d-inline-block' style='line-height:1em;'>[${vendedor.codven}] ${vendedor.nombre}</span>
                        <button class="btn btn-warning2 btn-outline-dark btn-sm btn-icon-map" id="btn-active-pin${key}" type="button" onclick="changePin(${key})"><i class="fas fa-map-marker"></i></button>
                    </div>                  
                  </div>
                  <div class="card-body p-0">
                    <table class="table table-sm">
                      <thead class="detalleActividad">
                        <tr style='font-size:0.8em;line-height:1.3em;'>
                          <th>Actividad</th>
                          <th>Cliente</th>
                          <th>Detalles</th>
                        </tr>
                      </thead>
                      <tbody class="detalleActividad">
                        ${actividad_html}
                      </tbody>
                    </table>
                    <table class="table table-sm table-striped table-dark" style='font-size:0.8em;line-height:1.3em;'>
                      <thead>
                        <tr>
                          <th>Actividad</th>
                          <th class='text-right'>Cliente</th>
                          <th class='text-right'>Detalles</th>
                        </tr>
                      </thead>
                      <tbody>               
                        <tr><td>Programaciones</td><td class='text-right'>${counter_programaciones}</td><td class='text-right'>&nbsp;</td></tr>
                        <tr><td>Visitas</td><td class='text-right'>${counter_visitas}</td><td class='text-right'>&nbsp;</td></tr>
                        <tr><td>Cumplimiento</td><td class='text-right'>&nbsp;</td><td class='text-right'>${counter_cumplimiento}%</td></tr>
                        <tr><td>Efectividad</td><td class='text-right'>&nbsp;</td><td class='text-right'>${counter_efectividad}%</td></tr>
                        <tr><td>Pedidos</td><td class='text-right'>${counter_ventas}</td><td class='text-right'>${currencyFormatter.format(Number(total_ventas))}</td></tr>
                        <tr><td>Cobros</td><td class='text-right'>${counter_cobros}</td><td class='text-right'>${currencyFormatter.format(Number(total_cobros))}</td></tr>                      
                      </tbody>            
                    </table>
                  </div>
                </div>
              </div>       
      `
    }
    

}