let t_h_cot;

let active_row=false;
let active_obj=false;

document.addEventListener('DOMContentLoaded', function(){
    //DataTables Historial Cotización - Ajax
    t_h_cot = $('#t_cotizacion_historial').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "cotizaciones/listarCotizacion",
            "dataSrc": ""
        },
        "columns": [{"data": "id"},
                    {"data": "nombre"},
                    {"data": "total"},
                    {"data": "fecha"},
                    {"data": "estado"},
        ],
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ]
    });
    $('#min').change(function (e) {
        t_h_cot.draw();
    });
    //Busqueda por Rango de Fechas DataTables - Hasta
    $('#max').change(function (e) {
        t_h_cot.draw();
    });

    t_h_cot.on( 'draw', function () {
        $('#t_cotizacion_historial tbody tr').removeClass('selected');
        activo_buttons(false)
    } );

    $('#t_cotizacion_historial tbody').on( 'click', 'tr', function (e) {
        let classList = e.currentTarget.classList;
       
        if (classList.contains('selected')) {
            classList.remove('selected');
        }
        else {
            t_h_cot.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
            classList.add('selected');
        }
        activo_buttons( t_h_cot.row( this ).data()  );
    } );

    function activo_buttons(obj)
    {
        active_obj=obj;
        active_row=active_obj.id;

        if($('#t_cotizacion_historial tbody tr.selected').length==0)
        {
            $('BUTTON.btn-toolbar-status').attr('disabled', 'disabled');
            $('BUTTON.btn-recuperar').hide();
            $('BUTTON.btn-eliminar').show();            
        } else {
            $('BUTTON.btn-toolbar-status').removeAttr('disabled');
            
            if(active_obj.estado_txt==='activo') {
                $('BUTTON.btn-recuperar').hide();
                $('BUTTON.btn-eliminar').show();
            } else {
                $('BUTTON.btn-recuperar').show();
                $('BUTTON.btn-eliminar').hide();
            }            
        }
    }

})

function generarPdfLocation(url) {
    var link = document.createElement("a");
    link.href = url;
    link.target = "_blank";
    link.click();
}

function verCotizacion(id) {
    const url = base_url + 'cotizaciones/verDetalle/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            document.getElementById('detalle_cliente').innerHTML = `
            <tr>
                <td>${res.cotizacion.nombre}</td>
                <td>${res.cotizacion.telefono}</td>
                <td>${res.cotizacion.direccion}</td>
            </tr>
            `;
            let html = '', td = '';
            res.productos.forEach(row => {
                if (parseFloat(row.cantidad) > parseFloat(row.stock)) {
                    td = '<badge class="badge badge-danger">Stock no Disponible</badge>';
                } else {
                    td = '<badge class="badge badge-danger">' + row.stock + '</badge>';
                }
                html += `
                    <tr>
                        <td>${row.cantidad}</td>
                        <td>${row.descripcion}</td>
                        <td>${row.precio}</td>
                        <td>${row.descuento}</td>
                        <td>${td}</td>
                        <td>${row.sub_total}</td>
                    </tr>
                `;
            });
            document.getElementById('detalle_cot').innerHTML = html;
            document.getElementById('fecha').value = res.cotizacion.fecha;
            document.getElementById('fecha_actual').value = res.fecha;
            if (res.cotizacion.condicion_pago == 1) {
                res.cotizacion.condicion_pago = 'Contado';
            } else {
                res.cotizacion.condicion_pago = 'Credito';
            }
            document.getElementById('validez_oferta').value = res.cotizacion.validez + ' Dias';
            document.getElementById('condicion_pago').value = res.cotizacion.condicion_pago;
            document.getElementById('nota').value = res.cotizacion.nota;
            document.getElementById('cotizacion_total').value = res.total_cotizacion;
            document.getElementById('restante').textContent = res.cotizacion.fecha_fin;
            document.getElementById('accionCot').innerHTML = `
                <button class="btn btn-primary" type="button" onclick="generarVenta(${res.cotizacion.id})"><i class="fas fa-print"></i> Procesar</button>
                <button class="btn btn-danger" type="button" data-dismiss="modal"><i class="fas fa-times-circle"></i> Cerrar</button>
                `;
            $('#verCotizacion').modal('show');
        }
    }
}
function generarVenta(id) {
    Swal.fire({
        title: 'Que desea Hacer?',
        showDenyButton: true,
        showCancelButton: true,
        confirmButtonText: `Generar venta`,
        denyButtonText: `Rechazar`,
        cancelButtonText: `Cancelar`,
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + 'cotizaciones/generarVenta/' + id + '/0';
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    console.log(this.responseText);
                    const res = JSON.parse(this.responseText);
                    $('#verCotizacion').modal('hide');
                    alertas(res.msg, res.icono);
                    if (res.folio) {
                        const ruta = base_url + 'ventas/generarPdf/' + res.folio;
                        setTimeout(() => {
                            window.open(ruta);
                        }, 2000);
                    }
                    t_h_cot.ajax.reload();
                }
            }
        } else if (result.isDenied) {
            const url = base_url + 'cotizaciones/verDetalle/' + id + '/2';
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                    $('#verCotizacion').modal('hide');
                    t_h_cot.ajax.reload();
                }
            }
        }
    })
}