let t_h_v;

let active_row=false;
let active_obj=false;
let active_index=false;

let fecha_min = document.getElementById('min');
let fecha_max = document.getElementById('max');

let estados = document.getElementById('estados');
let tipo = document.getElementById('tipo');

document.addEventListener('DOMContentLoaded', function () {

    t_h_v = $('#t_ventas').DataTable({

        "processing": true,
        "serverSide": true,
        "deferRender" : true,
        "sAjaxSource": "" + base_url + 'pedidos/listar_pedidos_ss',

        "fnServerParams": function ( aoData ) {
            aoData.push( { "name": "fecha_desde", "value": fecha_min.value},
                         { "name": "fecha_hasta", "value": fecha_max.value},
                         { "name": "estados", "value": estados.value},
                         { "name": "tipo", "value": tipo.value},
                        )
        },

        "type": 'POST',

        "columnDefs": [

            {   
                responsivePriority: 30000, 
                targets: -2, 
            },
            { responsivePriority: 30000, targets: -1 },
        ],
        "drawCallback": function () {
                let api = this.api();

                /*$(api.columns(2).footer()).html(
                    formatMoneyGTQ(Number(api.ajax.json().total).toFixed(2))
                )*/
                //total_ventas.innerHTML = '<strong>TOTAL VENTAS:</strong> '+ formatMoneyGTQ(Number(api.ajax.json().total).toFixed(2));

            },
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "responsive": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ],


    });

    t_h_v.on( 'draw', function () {
        $('#t_ventas tbody tr').removeClass('selected');
        activo_buttons(false)
    } );

    $('#t_ventas tbody').on( 'click', 'tr', function (e) {
        let classList = e.currentTarget.classList;
        let rowIndex = t_h_v.row( this ).index(); // Obtener el índice de la fila
       
        if (classList.contains('selected')) {
            classList.remove('selected');
        }
        else {
           t_h_v.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
            classList.add('selected');
        }
        activo_buttons( t_h_v.row( this ).data(), rowIndex  );
    } );

    fecha_min.onchange = function () { t_h_v.draw(); }
    fecha_max.onchange = function () { t_h_v.draw(); }
    estados.onchange = function () { t_h_v.draw(); }
    tipo.onchange = function () { t_h_v.draw(); }

    function activo_buttons(obj, index = null)
    {
        active_obj=obj;
        active_row=active_obj[0];
        active_index=index;

        if($('#t_ventas tbody tr.selected').length==0)
        {
            $('BUTTON.btn-toolbar-status').attr('disabled', 'disabled');
            $('BUTTON.btn-recuperar').hide();
            $('BUTTON.btn-eliminar').show();            
        } else {
            $('BUTTON.btn-toolbar-status').removeAttr('disabled');
            if(active_obj.estado_txt==='pagado' || active_obj.estado_txt==='pendiente') {
                $('BUTTON.btn-anular').show();
            } else {
                $('BUTTON.btn-anular').hide();
            }
            
        }
    }
    

    $('#min').change(function (e) {
        t_h_v.draw();
    });
    //Busqueda por Rango de Fechas DataTables - Hasta
    $('#max').change(function (e) {
        t_h_v.draw();
    });
})

function limpiar_busqueda()
{
    fecha_min.value = '';
    fecha_max.value = '';
    estados.value='';
    tipo.value='';
    t_h_v.search('');
    t_h_v.ajax.reload();
}

function btnReporteCli(id)
{
    if(id===false) return
    window.open(base_url +'clientes/dashboard/'+id, "_blank");
}


function btnStatus(id)
{
    // Estados exactos de tu select HTML
    const estadosOptions = {
        'P': 'PENDIENTE',
        'E': 'EMITIDO', 
        'A': 'AUTORIZADO',
        'I': 'IMPRESO',
        'F': 'FACTURADO',
        'D': 'DESPACHADO',
        'R': 'RETENIDO',
        'X': 'ANULADO'
    };

    let html = active_obj[6];
    let match = html.match(/>([^<]+)</);
    let estado_txt = match ? match[1] : '';
    let clave = Object.keys(estadosOptions).find(key => estadosOptions[key] === estado_txt.toUpperCase());

    //console.log(estado_txt, clave, id)
    
    Swal.fire({
        title: '<i class="fas fa-edit text-primary"></i> Cambiar Estado del Pedido',
        html: `
            <div class="mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-light text-center">
                        <h6 class="mb-0"><i class="fas fa-file-alt text-info"></i> Información del Pedido</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">
                                <strong><i class="fas fa-hashtag text-secondary"></i> ID:</strong><br>
                                <span class="badge badge-dark">${active_obj[0]}</span>
                            </div>
                            <div class="col-6">
                                <strong><i class="fas fa-flag text-warning"></i> Estado Actual:</strong><br>
                                <span class="badge badge-info">${estado_txt}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `,
        input: 'select',
        inputOptions: estadosOptions,
        inputValue: clave,
        inputPlaceholder: 'Selecciona el nuevo estado...',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#dc3545',
        confirmButtonText: '<i class="fas fa-save"></i> Cambiar Estado',
        cancelButtonText: '<i class="fas fa-times"></i> Cancelar',
        width: '600px',
        padding: '2rem',
        background: 'linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%)',
        backdrop: `
            rgba(0,0,0,0.8)
            url("data:image/svg+xml,%3csvg width='100' height='100' xmlns='http://www.w3.org/2000/svg'%3e%3cdefs%3e%3cpattern id='a' patternUnits='userSpaceOnUse' width='20' height='20' patternTransform='scale(2) rotate(0)'%3e%3crect x='0' y='0' width='100%25' height='100%25' fill='hsla(0,0%25,100%25,0)'/%3e%3cpath d='m0 20h20v-20h-20z' fill='hsla(0,0%25,100%25,0.03)'/%3e%3c/pattern%3e%3c/defs%3e%3crect width='100%25' height='100%25' fill='url(%23a)'/%3e%3c/svg%3e")
            left top
            repeat
        `,
        customClass: {
            popup: 'swal2-rounded-custom',
            title: 'swal2-title-custom',
            htmlContainer: 'swal2-html-custom',
            input: 'form-control form-control-lg',
            confirmButton: 'btn btn-success btn-lg px-4',
            cancelButton: 'btn btn-danger btn-lg px-4'
        },
        inputValidator: (value) => {
            if (!value) {
                return 'Debes seleccionar un estado';
            }
            if (value === clave) {
                return 'Has seleccionado el mismo estado actual';
            }
        },
        didOpen: () => {
            // Agregar estilos personalizados
            const style = document.createElement('style');
            style.textContent = `
                .swal2-rounded-custom {
                    border-radius: 15px !important;
                    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25) !important;
                }
                .swal2-title-custom {
                    font-size: 1.5rem !important;
                    font-weight: 600 !important;
                    margin-bottom: 1rem !important;
                }
                .swal2-html-custom {
                    margin: 0 !important;
                }
                .swal2-select {
                    border: 2px solid #e3e6f0 !important;
                    border-radius: 10px !important;
                    padding: 12px 15px !important;
                    font-size: 1.1rem !important;
                    transition: all 0.3s ease !important;
                }
                .swal2-select:focus {
                    border-color: #007bff !important;
                    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25) !important;
                }
            `;
            document.head.appendChild(style);
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const estadoSeleccionado = result.value;
            cambiarEstadoPedido(active_obj[0], estadoSeleccionado)
        }
    });
}

function cambiarEstadoPedido(idPedido, codigoEstado) {

    $.ajax({
        url: base_url + 'pedidos/cambiarEstadoPedido',
        method: 'POST',
        data: {
            id: idPedido,
            estado: codigoEstado,
        },
        success: function(response) {
            t_h_v.draw();
        },
        error: function(xhr, status, error) {
            console.error('Error AJAX:', xhr, status, error);
            Swal.fire({
                icon: 'error',
                title: 'Error de conexión',
                html: `
                    <div>
                        <p>No se pudo conectar con el servidor</p>
                        <small class="text-muted">Error: ${error}</small>
                    </div>
                `,
                confirmButtonText: 'Reintentar',
                showCancelButton: true,
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Reintentar
                    cambiarEstadoPedido(idPedido, codigoEstado);
                }
            });
        }
    });
}

function btnType(id)
{
    // Estados exactos de tu select HTML
    const estadosOptions = {
        'P': 'PEDIDO',
        'C': 'COMPLEMENTO', 
        'R': 'RAPIDITO',
    };

    let html = active_obj[5];
    let match = html.match(/>([^<]+)</);
    let estado_txt = match ? match[1] : '';
    let clave = Object.keys(estadosOptions).find(key => estadosOptions[key] === estado_txt.toUpperCase());

    //console.log(estado_txt, clave, id)
    
    Swal.fire({
        title: '<i class="fas fa-edit text-primary"></i> Cambiar Tipo de Pedido',
        html: `
            <div class="mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-light text-center">
                        <h6 class="mb-0"><i class="fas fa-file-alt text-info"></i> Información del Pedido</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">
                                <strong><i class="fas fa-hashtag text-secondary"></i> ID:</strong><br>
                                <span class="badge badge-dark">${active_obj[0]}</span>
                            </div>
                            <div class="col-6">
                                <strong><i class="fas fa-flag text-warning"></i> Estado Actual:</strong><br>
                                <span class="badge badge-info">${estado_txt}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `,
        input: 'select',
        inputOptions: estadosOptions,
        inputValue: clave,
        inputPlaceholder: 'Selecciona el nuevo tipo...',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#dc3545',
        confirmButtonText: '<i class="fas fa-save"></i> Cambiar Tipo',
        cancelButtonText: '<i class="fas fa-times"></i> Cancelar',
        width: '600px',
        padding: '2rem',
        background: 'linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%)',
        backdrop: `
            rgba(0,0,0,0.8)
            url("data:image/svg+xml,%3csvg width='100' height='100' xmlns='http://www.w3.org/2000/svg'%3e%3cdefs%3e%3cpattern id='a' patternUnits='userSpaceOnUse' width='20' height='20' patternTransform='scale(2) rotate(0)'%3e%3crect x='0' y='0' width='100%25' height='100%25' fill='hsla(0,0%25,100%25,0)'/%3e%3cpath d='m0 20h20v-20h-20z' fill='hsla(0,0%25,100%25,0.03)'/%3e%3c/pattern%3e%3c/defs%3e%3crect width='100%25' height='100%25' fill='url(%23a)'/%3e%3c/svg%3e")
            left top
            repeat
        `,
        customClass: {
            popup: 'swal2-rounded-custom',
            title: 'swal2-title-custom',
            htmlContainer: 'swal2-html-custom',
            input: 'form-control form-control-lg',
            confirmButton: 'btn btn-success btn-lg px-4',
            cancelButton: 'btn btn-danger btn-lg px-4'
        },
        inputValidator: (value) => {
            if (!value) {
                return 'Debes seleccionar un tipo';
            }
            if (value === clave) {
                return 'Has seleccionado el mismo tipo actual';
            }
        },
        didOpen: () => {
            // Agregar estilos personalizados
            const style = document.createElement('style');
            style.textContent = `
                .swal2-rounded-custom {
                    border-radius: 15px !important;
                    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25) !important;
                }
                .swal2-title-custom {
                    font-size: 1.5rem !important;
                    font-weight: 600 !important;
                    margin-bottom: 1rem !important;
                }
                .swal2-html-custom {
                    margin: 0 !important;
                }
                .swal2-select {
                    border: 2px solid #e3e6f0 !important;
                    border-radius: 10px !important;
                    padding: 12px 15px !important;
                    font-size: 1.1rem !important;
                    transition: all 0.3s ease !important;
                }
                .swal2-select:focus {
                    border-color: #007bff !important;
                    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25) !important;
                }
            `;
            document.head.appendChild(style);
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const tipoSeleccionado = result.value;
            cambiarTipoPedido(active_obj[0], tipoSeleccionado)
        }
    });

}

function cambiarTipoPedido(idPedido, codigoTipo) {

    $.ajax({
        url: base_url + 'pedidos/cambiarTipoPedido',
        method: 'POST',
        data: {
            id: idPedido,
            tipo: codigoTipo,
        },
        success: function(response) {
            t_h_v.draw();
        },
        error: function(xhr, status, error) {
            console.error('Error AJAX:', xhr, status, error);
            Swal.fire({
                icon: 'error',
                title: 'Error de conexión',
                html: `
                    <div>
                        <p>No se pudo conectar con el servidor</p>
                        <small class="text-muted">Error: ${error}</small>
                    </div>
                `,
                confirmButtonText: 'Reintentar',
                showCancelButton: true,
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Reintentar
                    cambiarTipoPedido(idPedido, codigoTipo);
                }
            });
        }
    });
}