const btnProcesar = document.getElementById('btnProcesar');
const id_cliente = document.getElementById('id_cliente');
const nombre = document.getElementById('nombre');
const contado = document.getElementById('contado');
const credito = document.getElementById('credito');
const efectivo_recibido = document.getElementById('efectivo_recibido');
const cambio = document.getElementById('cambio');
const anotacion = document.getElementById('anotacion');
const form = document.getElementById('formulario');

const serie = document.getElementById('serie');
const btnClientesHide = document.getElementById('btnClientesHide');
const btnClientesShow = document.getElementById('btnClientesShow');
const areaCliente = document.getElementById('areaCliente');
const areaClienteMinimizado = document.getElementById('areaClienteMinimizado');

const customCheck = document.getElementById("customCheck");
const buscarClienteContainer = document.getElementById("buscarClienteContainer");
const ClienteContainer = document.getElementById("ClienteContainer");
const buscarCliente = document.getElementById("buscarCliente");
const nombreCliente = document.getElementById("nombreCliente");
const vendedores = document.getElementById("vendedores");
const fecha = document.getElementById("fecha");

const tipoid_cliente = document.getElementById('tipoid_cliente');
const nit_cliente = document.getElementById('nit_cliente');
const direccion_cliente = document.getElementById('direccion_cliente');


let showCliente=true;
let countAutocomplete=0;

document.addEventListener('DOMContentLoaded', function () {
    cargarDetalle(true)

    //Autocomplete - Jquery UI, Buscar Clientes para la Venta
    $("#buscarCliente").autocomplete({
        minLength: 2,
        source: function (request, response) {
            $.ajax({
                url: base_url + 'clientes/buscarCliente',
                dataType: "json",
                data: {
                    q: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('id_cliente').value = ui.item.id;
            document.getElementById('id_cliente_badge').innerHTML = ui.item.id;
            document.getElementById('tipoid_cliente').value = ui.item.tipoid;
            document.getElementById('nit_cliente').value = ui.item.nit;
            document.getElementById('direccion_cliente').value = ui.item.direccion;
            vendedores.value=ui.item.vendedor;
        },
      
    })
    //Autocomplete - Jquery UI, Buscar Productos para la Venta
    $("#buscarProducto").autocomplete({
        minLength: 2,
        classes: {"ui-autocomplete": "height-max-autocomplete"},
        source: function (request, response) {
            $.ajax({
                url: base_url + 'ventas/buscarProducto',
                dataType: "json",
                data: {
                    pro: request.term
                },
                success: function (data) {
                    if (data.length > 0) {
                        var result = Object.values(data);
                        response( Object.values(data) );
                    } else {
                        document.getElementById('error_producto').textContent = 'No hay Producto Similar';
                    }
                }
            });
        },
        response: function( event, ui ) { countAutocomplete=-1; },
        classes: { "ui-autocomplete": "autocompleteOverflow" },                
        select: function (event, ui) {
            document.getElementById('error_producto').textContent = '';
            const id_pro = ui.item.id;
            ingresarVenta(id_pro);
        },
        create: function (event,ui){

            $(this).autocomplete( "instance" )._renderItem = function (ul, item) {

                countAutocomplete++;                

                return $( "<li></li>" )
                .data("item.autocomplete", item)
                .append(`<div class='autocompleteProduct'>
                    <div class="row">
                        <div class='col-12 col-md-2'>
                            <img src="https://ad.divemosa.com/inventario/Assets/img/pro/${item.foto}">
                        </div>
                        <div class='col-12 col-md-8'>
                            <h3 class='mb-0 '>${item.descripcion}</h3>
                            <p class='mb-0 d-none'>${item.detalles}</p>
                            <h4 class='mb-0'>
                                <span class="badge badge-warning">${item.value}</span>
                                <span class="badge badge-secondary">${item.value_alter}</span>
                            </h4>
                            <p class='mb-0 d-none'>${item.observaciones}</p>
                        </div>
                        <div class='col-12 col-md-2'>
                            <h2 class='text-right mb-0'><strong>Q.${item.precio}</strong></h2>
                            <h2 class='text-right'><span class="badge badge-danger">Existencia ${item.cantidad}</span></h6>
                        </div>
                    </div>
                </div>`)                
                /*.append(`<div class='autocompleteProduct'>
                    <div class="row">
                        <div class='col-12 col-md-2'>
                            <img src="https://ad.divemosa.com/inventario/Assets/img/pro/${item[countAutocomplete].foto}">
                        </div>
                        <div class='col-12 col-md-8'>
                            <h3 class='mb-0 '>${item[countAutocomplete].descripcion}</h3>
                            <p class='mb-0'>${item[countAutocomplete].detalles}</p>
                            <h4 class='mb-0'>
                                <span class="badge badge-warning">${item[countAutocomplete].codigo}</span>
                                <span class="badge badge-secondary">${item[countAutocomplete].codigo_alter}</span>
                            </h4>
                            <p class='mb-0'>${item[countAutocomplete].observaciones}</p>
                        </div>
                        <div class='col-12 col-md-2'>
                            <h2 class='text-right mb-0'><strong>Q.${item[countAutocomplete].precio_venta}</strong></h2>
                            <h2 class='text-right'><span class="badge badge-danger">Existencia ${item[countAutocomplete].cantidad}</span></h6>
                        </div>
                    </div>
                </div>`)*/
                .appendTo( ul );
            };
        }          
    })

    btnProcesar.addEventListener('click', generarVenta)
    btnClientesHide.addEventListener('click', toggleClientes);
    btnClientesShow.addEventListener('click', toggleClientes);    

    fecha.value = new Date().toISOString().substring(0, 10);

    var forms = document.getElementsByClassName('needs-validation');
    // Loop over them and prevent submission
    var validation = Array.prototype.filter.call(forms, function (form) {
        form.addEventListener('submit', function (event) {
            event.preventDefault();
            if (form.checkValidity() === false) {
                event.stopPropagation();
                form.classList.add('was-validated');
            } else {
                const url = base_url + 'clientes/registrar';
                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(new FormData(this));
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.icono == 'success') {
                            $('#nuevo_cliente').modal('hide');
                        }
                    }
                }
            }

        }, false);
    });

})

function toggleClientes()
{
    showCliente=!showCliente;

    if(showCliente===true)
    {
        btnClientesHide.classList.remove("d-none")
        btnClientesShow.classList.add("d-none")
        areaCliente.classList.remove("d-none")
        areaClienteMinimizado.classList.add("d-none")
    } else {
        btnClientesHide.classList.add("d-none")
        btnClientesShow.classList.remove("d-none")
        areaCliente.classList.add("d-none")
        areaClienteMinimizado.classList.remove("d-none")

        let nombre_cliente=(customCheck.checked===true)?nombreCliente.value:buscarCliente.value;
        if(nombre_cliente.toString().trim()=='') nombre_cliente='No seleccionado'

        areaClienteMinimizado.innerHTML=`
            <p class='mb-0'>
            <span class='mr-1'><strong>Cliente:</strong> ${nombre_cliente}</span>
            <span class="badge badge-secondary mr-1">Serie: ${(serie.value=='1')?'AD':'DIVEMOSA'}</span>
            </p>
        `
    }  
}

function frmCliente() {
    document.getElementById('id').value= '';
    document.getElementById('title').textContent = 'Nuevo Cliente';
    document.getElementById('btnAccion').textContent = 'Registrar';
    form.reset();
    $('#nuevo_cliente').modal('show');
}

function ingresarVenta(id_pro) {
    const url = base_url + 'ventas/ingresar/' + id_pro;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {

            const res = JSON.parse(this.responseText);

            cargarDetalle();
            document.getElementById('buscarProducto').value = '';
            document.getElementById('buscarProducto').focus();
            alertas(res.msg, res.icono);
            return false;
        }
    }
}

function cantidadVenta(e, id) {
    const url = base_url + 'ventas/cantidadVenta/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            if (res.icono != 'success') {
                alertas(res.msg, res.icono);
            }
            cargarDetalle();
            return false;
        }
    }
}

function cargarDetalle(loadSelect=false) {

    const url = base_url + 'ventas/listar/detalle_temp';
    const http = new XMLHttpRequest();
    let select = document.getElementById('serie');
    let option =null;

    let bgcebra ='bg-light';

    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            let html = '';
            res.detalle.forEach(row => {
                bgcebra=(bgcebra=='')?'bg-light':'';
                html += `
                <tr class='${bgcebra}'>
                    <td class='d-table-cell d-md-none p-2' style='border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;'> 
                        <img src="https://ad.divemosa.com/inventario/Assets/img/pro/${row['foto']}" style='width:100px;border:1px solid #eee;border-radius: 5px;'>
                    </td>
                    <td colspan='4' class='d-table-cell d-md-none' style='text-align:left;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;'>
                        <h5 class='text-primary pl-2 pr-2' style='font-weight:bold;'>${row['descripcion']}</h5>    
                    </td>
                </tr>
                <tr class='${bgcebra}'>
                    <td class='d-none d-md-table-cell p-2' style='border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:155px;'>
                        <img src="https://ad.divemosa.com/inventario/Assets/img/pro/${row['foto']}" style='width:125px;border:1px solid #eee;border-radius: 5px;'>
                    </td>
                    <td class='d-none d-md-table-cell' style='text-align:left;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;'>
                        <h5 class='text-primary' style='font-weight:bold;'>${row['descripcion']}</h5>    
                        <h5 class='text-dark' style='font-weight:bold;'>Q.${row['sub_total']}</h5>
                    </td>
                    <td class='pl-2' style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:100px;'>
                        <small class='text-muted' style='font-size:10px;'>CANTIDAD</small>
                        <input type="text" class="form-control" min="1" value="${row['cantidad']}" onchange="cantidadVenta(event, ${row['id']})">
                    </td>

                    <td style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:100px;'>
                        <small class='text-muted' style='font-size:10px;'>PRECIO</small>
                        <input type="text" class="form-control" step="1.00" min="1" value="${row['precio']}" onchange="precioProducto(event, ${row['id']})">
                    </td>

                    <td style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:100px;'>
                        <small class='text-muted' style='font-size:10px;'>DESCUENTO</small>
                        <input type="text" class="form-control" step="0.01" min="0.01" value="${row['descuento']}" onchange="descuentoVenta(event, ${row['id']})">
                    </td>

                    <td style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:34px;padding-bottom:10px;width:60px;'>
                        <button class="btn btn-danger" type="button" onclick="eliminar(${row['id']})"><i class="fas fa-trash-alt"></i></button>                    
                    </td>
                </tr>
                <tr class='${bgcebra}'>
                    <td colspan='4' class='d-table-cell d-md-none' style='text-align:left;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;'>
                        <h5 class='text-dark pl-2' style='font-weight:bold;'><small class='font-weight-normal'>TOTAL</small> Q.${row['sub_total']}</h5>
                    </td>
                </tr>`;
               //https://ad.sismosoluciones.com/Assets/img/pro/default.png               
            });
            document.getElementById("t_ven").innerHTML = html;
            document.getElementById("total").value = res.total_pagar.total;

            if(loadSelect===true)
            {
                let selectedOption = select.value;
                select.innerHTML = '';          
                res.series.forEach(row => {
                    option = document.createElement('option');
                    option.value = row['iduser'];
                    option.text = `[${row['iduser']}] ${row['user']}`;
                    select.appendChild(option);
                });
            }

            let selectedOptionVendedores = vendedores.value;
            vendedores.innerHTML = '';          
            res.vendedores.forEach(row => {
                option = document.createElement('option');
                option.value = row['codven'];
                option.text = `[${row['codven']}] ${row['nombre']}`;
                vendedores.appendChild(option);
            });

            if(selectedOptionVendedores!='') vendedores.value=selectedOptionVendedores;

        }
    }
}

function precioProducto(e, id) {
    const url = base_url + 'ventas/precioProducto/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            cargarDetalle();
            alertas(res.msg, res.icono);
        }
    }
}

function descuentoVenta(e, id) {
    const url = base_url + 'ventas/descuentoVenta/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
            return false;
        }
    }
}

function clienteCustom(logic)
{
    buscarCliente.value='';
    nombreCliente.value='';

    document.getElementById('id_cliente').value = 1;
    document.getElementById('id_cliente_badge').innerHTML = '';
    document.getElementById('tipoid_cliente').value = 1;
    document.getElementById('nit_cliente').value = 'CF';
    document.getElementById('direccion_cliente').value = 'GUATEMALA, CIUDAD';

    if(logic===true)
    {
        id_cliente.value=0;
        buscarClienteContainer.classList.add("d-none");
        ClienteContainer.classList.remove("d-none");
    } else {
        id_cliente.value=1;
        buscarClienteContainer.classList.remove("d-none");
        ClienteContainer.classList.add("d-none");
    }
}


function eliminar(id) {
    const url = base_url + 'ventas/delete/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
        }
    }
}

function generarVenta(e) {
    e.preventDefault();
    Swal.fire({
        title: 'Esta seguro de procesar la Venta?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            let fila = document.querySelectorAll("#t_ventas_hist tr").length;

            if (fila < 1) {
                alertas('No hay productos para proceder con la venta', 'warning');
                return false;
            } else {
                const url = base_url + 'ventas/generarVenta';
                const data = new FormData();
                data.append('id_cliente', id_cliente.value);
                data.append('credito', credito.checked);
                data.append('contado', contado.checked);
                data.append('serie', serie.value);
                data.append('anotacion', anotacion.value);
                data.append('id_vendedor', vendedores.value);
                data.append('fecha', fecha.value);

                data.append('tipoid', tipoid_cliente.value);
                data.append('nit', nit_cliente.value);
                data.append('direccion', direccion_cliente.value);

                if(customCheck.checked===true) {
                    data.append('nombre_cliente', nombreCliente.value);
                    data.append('mostrador', 1);
                } else {
                    data.append('nombre_cliente', '');
                    data.append('mostrador', 0);                    
                }

                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(data);
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.folio) {
                            let ruta;
                            if (tipoPdf) {
                                ruta = base_url + 'ventas/ticket/' + res.folio;
                            } else {
                                ruta = base_url + 'ventas/generarPdf/' + res.folio;
                            }
                            window.open(ruta);
                            setTimeout(() => {
                                window.location.reload();
                            }, 2000);
                        }
                    }
                }
            }

        }
    })
}