<?php
$debug=false;

if($debug===true)
{
    $firmar_documento="https://dev.api.soluciones-mega.com/api/solicitaFirma";
    $solicitar_token="https://dev2.api.ifacere-fel.com/api/solicitarToken";
    $verificar_documento="https://dev2.api.ifacere-fel.com/api/verificarDocumento";
    $registrar_xml="https://dev2.api.ifacere-fel.com/api/registrarDocumentoXML";
    $anular_documento="https://dev2.api.ifacere-fel.com/api/anularDocumentoXML";
    $retornar_xml="https://dev2.api.ifacere-fel.com/api/retornarXML";
    $retornar_pdf="https://dev2.api.ifacere-fel.com/api/retornarPDF";

} else {
    $firmar_documento="https://api.soluciones-mega.com/api/solicitaFirma";
    $solicitar_token="https://apiv2.ifacere-fel.com/api/solicitarToken";
    $verificar_documento="https://apiv2.ifacere-fel.com/api/verificarDocumento";
    $registrar_xml="https://apiv2.ifacere-fel.com/api/registrarDocumentoXML";
    $anular_documento="https://apiv2.ifacere-fel.com/api/anularDocumentoXML";
    $retornar_xml="https://apiv2.ifacere-fel.com/api/retornarXML";
    $retornar_pdf="https://apiv2.ifacere-fel.com/api/retornarPDF";
}

DEFINE('EMISOR_AfiliacionIVA', 'GEN');
DEFINE('EMISOR_CodigoEstablecimiento', 1);
DEFINE('EMISOR_CodigoPostal', '01064');
DEFINE('EMISOR_CorreoEmisor', 'contabilidad@macegua.com');
DEFINE('EMISOR_Departamento', 'Guatemala');
DEFINE('EMISOR_Municipio', 'Villa Nueva');
DEFINE('EMISOR_Direccion', 'Ciudad');
DEFINE('EMISOR_NIT', '18237029');
DEFINE('EMISOR_NombreComercial', 'MACEGUA');
DEFINE('EMISOR_NombreEmisor', 'GUSTAVO EDUARDO SECAIDA ZEPEDA');

/*'EMISOR_AfiliacionIVA' -> ws_users.aficiacion_iva
'EMISOR_CodigoEstablecimiento' -> ws_users.establecimiento
'EMISOR_CodigoPostal' -> ws_users.cpostal
'EMISOR_CorreoEmisor' -> ws_users.correo
'EMISOR_Departamento' -> ws_users.departamento
'EMISOR_Municipio' -> ws_users.municipio
'EMISOR_Direccion' -> ws_users.direccion
'EMISOR_NIT' -> ws_users.nit
'EMISOR_NombreComercial' -> ws_users.comercio
'EMISOR_NombreEmisor' -> ws_users.emisor
{{TIPODOCUMENTO}} -> ws_users.tipo_fact
*/

/*$userFEL='18237029';
$apiKEY='Ohtzr0lgN3jmMtMyCcj43r1';*/

/*$requestXML_solicitarToken="<?xml version='1.0' encoding='UTF-8'?>
<SolicitaTokenRequest>
	<usuario>{$userFEL}</usuario>
	<apikey>{$apiKEY}</apikey>
</SolicitaTokenRequest>";*/

$requestXML_solicitarToken="<?xml version='1.0' encoding='UTF-8'?>
<SolicitaTokenRequest>
	<usuario>{{USERFEL}}</usuario>
	<apikey>{{APIKEY}}</apikey>
</SolicitaTokenRequest>";

$requestXML_header="<?xml version='1.0' encoding='UTF-8'?>
<FirmaDocumentoRequest id='{{UUID}}'>
<xml_dte>
<![CDATA[
<?xml version='1.0' encoding='UTF-8' standalone='no'?>
<dte:GTDocumento xmlns:dte='http://www.sat.gob.gt/dte/fel/0.2.0' Version='0.1' xmlns:xd='http://www.w3.org/2000/09/xmldsig#'>
    <dte:SAT ClaseDocumento='dte'>
        <dte:DTE ID='DatosCertificados'>
            <dte:DatosEmision ID='DatosEmision'>
                <dte:DatosGenerales CodigoMoneda='GTQ' FechaHoraEmision='{{FECHAHORAEMISION}}' Tipo='{{TIPODOCUMENTO}}'/>
                <dte:Emisor AfiliacionIVA='{{EMISOR_AfiliacionIVA}}' CodigoEstablecimiento='{{EMISOR_CodigoEstablecimiento}}' CorreoEmisor='{{EMISOR_CorreoEmisor}}' NITEmisor='{{EMISOR_NIT}}' NombreComercial='{{EMISOR_NombreComercial}}' NombreEmisor='{{EMISOR_NombreEmisor}}'>
                    <dte:DireccionEmisor>
                        <dte:Direccion>{{EMISOR_Direccion}}</dte:Direccion>
                        <dte:CodigoPostal>{{EMISOR_CodigoPostal}}</dte:CodigoPostal>
                        <dte:Municipio>{{EMISOR_Municipio}}</dte:Municipio>
                        <dte:Departamento>{{EMISOR_Departamento}}</dte:Departamento>
                        <dte:Pais>GT</dte:Pais>
                    </dte:DireccionEmisor>

                </dte:Emisor>
                <dte:Receptor CorreoReceptor='' IDReceptor='{{NITRECEPTOR}}' NombreReceptor='{{NOMBRERECEPTOR}}' {{TIPOESPECIAL}}>
                    <dte:DireccionReceptor>
                        <dte:Direccion>{{DIRECCIONRECEPTOR}}</dte:Direccion>
                        <dte:CodigoPostal>{{CPRECEPTOR}}</dte:CodigoPostal>
                        <dte:Municipio>{{MUNICIPIORECEPTOR}}</dte:Municipio>
                        <dte:Departamento>{{DEPARTAMENTORECEPTOR}}</dte:Departamento>
                        <dte:Pais>{{PAISRECEPTOR}}</dte:Pais>
                    </dte:DireccionReceptor>
                </dte:Receptor>
                <dte:Frases>
                    <dte:Frase CodigoEscenario='1' TipoFrase='1'/>
                    <dte:Frase CodigoEscenario='1' TipoFrase='2'/>
                </dte:Frases>
                <dte:Items>
{{ITEMS}}
                </dte:Items>
                <dte:Totales>
                    <dte:TotalImpuestos>
                        <dte:TotalImpuesto NombreCorto='IVA' TotalMontoImpuesto='{{TOTALMONTOIMPUESTO}}'/>
                    </dte:TotalImpuestos>
                    <dte:GranTotal>{{GRANTOTAL}}</dte:GranTotal>
                </dte:Totales>

                <dte:Complementos>
                    <dte:Complemento IDComplemento='' NombreComplemento='' URIComplemento='http://www.sat.gob.gt/dte/fel/CompCambiaria/0.1.0'>
                        <cfc:AbonosFacturaCambiaria xmlns:cfc='http://www.sat.gob.gt/dte/fel/CompCambiaria/0.1.0' Version='1'>
                            <cfc:Abono>
                                <cfc:NumeroAbono>1</cfc:NumeroAbono>
                                <cfc:FechaVencimiento>{{FECHAVENCIMIENTO}}</cfc:FechaVencimiento>
                                <cfc:MontoAbono>{{GRANTOTAL}}</cfc:MontoAbono>
                            </cfc:Abono>
                        </cfc:AbonosFacturaCambiaria>
                    </dte:Complemento>
                </dte:Complementos>

            </dte:DatosEmision>

            </dte:DTE>

            <dte:Adenda>
                <dte:AdendaDetail id='AdendaSummary'>
                    <dte:AdendaSummary>
                        <dte:Valor1>{{CODIGOVENDEDOR}}</dte:Valor1>
			   <dte:Valor2>{{NUMDOC}}</dte:Valor2>
                    </dte:AdendaSummary>
                </dte:AdendaDetail>
            </dte:Adenda>

    </dte:SAT>
    </dte:GTDocumento>
    ]]>
    </xml_dte>
</FirmaDocumentoRequest>";


$requestXMLnotacredito_header="<?xml version='1.0' encoding='UTF-8'?>
<FirmaDocumentoRequest id='{{UUID}}'>
<xml_dte>
<![CDATA[
<?xml version='1.0' encoding='UTF-8' standalone='no'?>
<dte:GTDocumento xmlns:dte='http://www.sat.gob.gt/dte/fel/0.2.0' xmlns:xd='http://www.w3.org/2000/09/xmldsig#' Version='0.1'>
    <dte:SAT ClaseDocumento='dte'>
        <dte:DTE ID='DatosCertificados'>
            <dte:DatosEmision ID='DatosEmision'>
                <dte:DatosGenerales CodigoMoneda='GTQ' FechaHoraEmision='{{FECHAHORAEMISION}}' Tipo='{{TIPODOCUMENTO}}'/>
                <dte:Emisor AfiliacionIVA='{{EMISOR_AfiliacionIVA}}' CodigoEstablecimiento='{{EMISOR_CodigoEstablecimiento}}' CorreoEmisor='{{EMISOR_CorreoEmisor}}' NITEmisor='{{EMISOR_NIT}}' NombreComercial='{{EMISOR_NombreComercial}}' NombreEmisor='{{EMISOR_NombreEmisor}}'>
                    <dte:DireccionEmisor>
                        <dte:Direccion>{{EMISOR_Direccion}}</dte:Direccion>
                        <dte:CodigoPostal>{{EMISOR_CodigoPostal}}</dte:CodigoPostal>
                        <dte:Municipio>{{EMISOR_Municipio}}</dte:Municipio>
                        <dte:Departamento>{{EMISOR_Departamento}}</dte:Departamento>
                        <dte:Pais>GT</dte:Pais>
                    </dte:DireccionEmisor>

                </dte:Emisor>
                <dte:Receptor CorreoReceptor='' IDReceptor='{{NITRECEPTOR}}' NombreReceptor='{{NOMBRERECEPTOR}}'>
                    <dte:DireccionReceptor>
                        <dte:Direccion>{{DIRECCIONRECEPTOR}}</dte:Direccion>
                        <dte:CodigoPostal>{{CPRECEPTOR}}</dte:CodigoPostal>
                        <dte:Municipio>{{MUNICIPIORECEPTOR}}</dte:Municipio>
                        <dte:Departamento>{{DEPARTAMENTORECEPTOR}}</dte:Departamento>
                        <dte:Pais>{{PAISRECEPTOR}}</dte:Pais>
                    </dte:DireccionReceptor>
                </dte:Receptor>

                <dte:Items>
{{ITEMS}}
                </dte:Items>
                <dte:Totales>
                    <dte:TotalImpuestos>
                        <dte:TotalImpuesto NombreCorto='IVA' TotalMontoImpuesto='{{TOTALMONTOIMPUESTO}}'/>
                    </dte:TotalImpuestos>
                    <dte:GranTotal>{{GRANTOTAL}}</dte:GranTotal>
                </dte:Totales>

                <dte:Complementos>

                    <dte:Complemento IDComplemento='ComplementoReferenciaNota' NombreComplemento='Complemento Referencia Nota' URIComplemento='http://www.sat.gob.gt/face2/ComplementoReferenciaNota/0.1.0'>
                        {{COMPLEMENTO}}                        
                    </dte:Complemento>

                </dte:Complementos>

            </dte:DatosEmision>

            </dte:DTE>

            <dte:Adenda>
                <dte:AdendaDetail id='AdendaSummary'>
                    <dte:AdendaSummary>
                        <dte:Valor1>{{CODIGOVENDEDOR}}</dte:Valor1>
			   <dte:Valor2>{{NUMDOC}}</dte:Valor2>
                    </dte:AdendaSummary>
                </dte:AdendaDetail>
            </dte:Adenda>

    </dte:SAT>
    </dte:GTDocumento>
    ]]>
    </xml_dte>
</FirmaDocumentoRequest>";

$requestXML_anulacion="<?xml version='1.0' encoding='UTF-8'?>
<FirmaDocumentoRequest id='{{UUID}}'>
<xml_dte>
<![CDATA[
<?xml version='1.0' encoding='UTF-8'?>
<ns:GTAnulacionDocumento xmlns:ds='http://www.w3.org/2000/09/xmldsig#' xmlns:ns='http://www.sat.gob.gt/dte/fel/0.1.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' Version='0.1'>
    <ns:SAT>
        <ns:AnulacionDTE ID='DatosCertificados'>
            <ns:DatosGenerales ID='DatosAnulacion' NumeroDocumentoAAnular='{{AUTORIZACION}}' NITEmisor='{{EMISOR_NIT}}' IDReceptor='{{NITCLIENTE}}' FechaEmisionDocumentoAnular='{{FECHAPROC}}' FechaHoraAnulacion='{{FECHAANUL}}' MotivoAnulacion='Error de facturación'/>
        </ns:AnulacionDTE>
    </ns:SAT>
</ns:GTAnulacionDocumento>
    ]]>
    </xml_dte>
</FirmaDocumentoRequest>";


function requestXML($requestXML,$service_url,$token)
{
    $curl = curl_init($service_url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-type: text/xml; charset=utf-8','Authorization: bearer '.$token));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $requestXML );
    $curl_response = curl_exec($curl);

    return json_decode(json_encode(new SimpleXMLElement($curl_response)),TRUE);
}

function requestToken($requestXML,$service_url)
{
    $curl = curl_init($service_url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-type: text/xml; charset=utf-8'));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $requestXML );
    $curl_response = curl_exec($curl);

    return json_decode(json_encode(new SimpleXMLElement($curl_response)),TRUE);
}

function gen_uuid() {
    $uuid = array(
    'time_low'  => 0,
    'time_mid'  => 0,
    'time_hi'  => 0,
    'clock_seq_hi' => 0,
    'clock_seq_low' => 0,
    'node'   => array()
    );

    $uuid['time_low'] = mt_rand(0, 0xffff) + (mt_rand(0, 0xffff) << 16);
    $uuid['time_mid'] = mt_rand(0, 0xffff);
    $uuid['time_hi'] = (4 << 12) | (mt_rand(0, 0x1000));
    $uuid['clock_seq_hi'] = (1 << 7) | (mt_rand(0, 128));
    $uuid['clock_seq_low'] = mt_rand(0, 255);

    for ($i = 0; $i < 6; $i++) {
    $uuid['node'][$i] = mt_rand(0, 255);
    }

    $uuid = sprintf('%08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x',
    $uuid['time_low'],
    $uuid['time_mid'],
    $uuid['time_hi'],
    $uuid['clock_seq_hi'],
    $uuid['clock_seq_low'],
    $uuid['node'][0],
    $uuid['node'][1],
    $uuid['node'][2],
    $uuid['node'][3],
    $uuid['node'][4],
    $uuid['node'][5]
    );

    return strtoupper($uuid);
}

function convert_id_number($number)
{
    if(trim($number)=='') return array('serial'=>'','number'=>'' );
    $explode_number=explode('-',$number);
    return array('serial'=>$explode_number[0],'number'=>hexdec($explode_number[1].$explode_number[2]) );
}

/*[1 ERRORES]:

FEL-GUI-56 | 3.7 | 3.7.1 | No. 1 | Error - Error. La fecha de emisión del documento a anular [12/02/2020] no coincide con la registrada en la SAT.*/

function mostrar_errores($aerrores)
{
    if(is_array($aerrores) AND !isset( $aerrores["cod_error"]) )
    {
        $errores='';
        foreach($aerrores as $value) {
            $errores.=$value["cod_error"].' - '.$value["desc_error"].' | ';
        }
        return json_encode(array('ERROR'=>true,'MENSAJE'=>'[REGISTRO] Código: '.$errores));
    } else {
        return json_encode(array('ERROR'=>true,'MENSAJE'=>'[REGISTRO] Código: '.$aerrores["cod_error"].' - '.$aerrores["desc_error"]));
    }
}

function mostrar_errores2($aerrores)
{
    $errores='';

    if(!isset( $aerrores["cod_error"]))
    {
        $count_error=count($aerrores);
        foreach($aerrores as $value) { $errores.='['.$value["cod_error"].']: '.$value["desc_error"]."\n\r"; }
    } else {
        $count_error=1;
        $errores.='['.$aerrores["cod_error"].']: '.$aerrores["desc_error"]."\n\r";
    }
    return '['.$count_error.' ERRORES]:'."\n\r".$errores;
}

function get_tag( $tag, $xml ) {
    $tag = preg_quote($tag);
    preg_match_all('{<'.$tag.'[^>]*>(.*?)</'.$tag.'>.}',$xml,$matches,PREG_PATTERN_ORDER);
    return $matches[1];
}